/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DnsFal_Functionlist.h 75815 2018-05-15 14:31:08Z trieu                $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------
     1         30.05.2012   TD
     Created
*******************************************************************************/

/*******************************************************************************
 * @file DnsFal_Functionlist.h
 * @brief Dns Fal - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_DnsFal</code>
 * of task.
 ******************************************************************************/
#ifndef __DNS_FAL_FUNCTIONLIST_H
#define __DNS_FAL_FUNCTIONLIST_H


/*******************************************************************************
 * @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 ******************************************************************************/

TLR_VOID
TaskExit_DnsFal
(
 TLR_VOID FAR* pvRsc
);

TLR_VOID
TaskLeave_DnsFal
(
TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_VOID
TaskEnter_DnsFal
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*******************************************************************************
 * @name Task Version
 *
 * Subsequently the version of task is defined.
 ******************************************************************************/

/** version of task startup parameter */
#define DNS_FAL_STARTUP_PARAM_VERSION (1)


/*******************************************************************************
 * @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 ******************************************************************************/

/** type of <code>DNS_FAL_STARTUPPARAMETER_Ttag</code> */
typedef struct DNS_FAL_STARTUPPARAMETER_Ttag  DNS_FAL_STARTUPPARAMETER_T;


/*******************************************************************************
 * Task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 ******************************************************************************/

#define MSK_DNS_FAL_STARTUP_FLAG_24V_INTERTED 0x00000001

struct DNS_FAL_STARTUPPARAMETER_Ttag    /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  TLR_UINT32  ulCfgFlag;  /* Config Flag  */
};

/** @} */


/******************************************************************************/
#endif /* #ifndef __DNS_FAL_FUNCTIONLIST_H */
